/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.Instrumentation;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import ibm.nways.lspeed.model.LsAtmModuleSnmpInstr;
import ibm.nways.lspeed.model.LsModuleSnmpInstr;

public class ModulePollAction
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.lspeed.LsGeneralResources";
    private boolean loggingOn = false;

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        String string = "GenericStatusName";
        Instrumentation instrumentation = statusModelInfo.getLocalModel().getInstr();
        if (instrumentation instanceof LsModuleSnmpInstr) {
            string = "LsModuleTable";
        } else if (instrumentation instanceof LsAtmModuleSnmpInstr) {
            string = "LsAtmModuleTable";
        }
        I18NString i18NString = new I18NString(bundleName, string);
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        String string = "GenericStatusName";
        Instrumentation instrumentation = statusModelInfo.getLocalModel().getInstr();
        if (instrumentation instanceof LsModuleSnmpInstr) {
            string = "Module";
        } else if (instrumentation instanceof LsAtmModuleSnmpInstr) {
            string = "AtmModule";
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, string, objectArray);
        if (this.loggingOn) {
            System.out.println("LS:ModulePollAction - ObjectName is " + string + " Instance " + objectArray[0].toString());
        }
        return i18NMsgFormat;
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
        if (statusModelInfo == null) {
            return;
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        if (!(statusModelInfo.get("ModuleInfo.ModStatus") instanceof Integer)) {
            statusAndExplain.statType = StatusType.UNKNOWN;
            statusAndExplain.explain = new I18NMsgFormat(bundleName, "ModuleStatusUnknown", objectArray);
            if (this.loggingOn) {
                System.out.println("LS:ModulePollAction - calculateStatus. Missing poll data for Module " + objectArray[0].toString());
            }
        } else {
            int n = (Integer)statusModelInfo.get("ModuleInfo.ModStatus");
            statusAndExplain = this.evaluateModuleStatus(n, objectArray);
            if (this.loggingOn) {
                System.out.println("LS:ModulePollAction - new status is " + statusAndExplain.statType + " " + statusAndExplain.explain.getTranslation());
            }
        }
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    private StatusAndExplain evaluateModuleStatus(int n, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        switch (n) {
            case 1: {
                statusAndExplain.statType = StatusType.NORMAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ModuleStatusNormal", objectArray);
                break;
            }
            case 20: {
                statusAndExplain.statType = StatusType.MARGINAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ModuleStatusBooting", objectArray);
                break;
            }
            case 21: {
                statusAndExplain.statType = StatusType.MARGINAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ModuleStatusPartialError", objectArray);
                break;
            }
            case 37: {
                statusAndExplain.statType = StatusType.MARGINAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ModuleStatusTransientError", objectArray);
                break;
            }
            case 31: {
                statusAndExplain.statType = StatusType.MARGINAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ModuleStatusMisMatch", objectArray);
                break;
            }
            case 30: {
                statusAndExplain.statType = StatusType.MARGINAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ModuleStatusNotIDown", objectArray);
                break;
            }
            case 10: {
                statusAndExplain.statType = StatusType.CRITICAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ModuleStatusDown", objectArray);
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ModuleStatusUnknown", objectArray);
            }
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NMsgFormat explain;

        StatusAndExplain() {
            ModulePollAction.this = ModulePollAction.this;
        }
    }
}

